﻿using Helper;
using Sunny.UI;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using ZSMusic.BLLEX;
using ZSMusic.Model;
using ZSMusic.Winform.Properties;

namespace ZSMusic.Winform
{
    public partial class FrmAdvanced : UIForm
    {
        public FrmMain MainForm { get; set; }

        public FrmAdvanced()
        {
            InitializeComponent();
        }

        public void ShowError(Exception ex)
        {
            FrmEx f = new FrmEx();
            f.Style = UIStyle.Red;
            f.Ex = ex;
            f.ShowDialog();
        }

        private void btn垃圾回收_Click(object sender, EventArgs e)
        {
            GC.Collect();
        }

        private void btn测试服务器_Click(object sender, EventArgs e)
        {
            ThreadPool.QueueUserWorkItem(delegate
            {
                Validate();
            }, null);
        }

        private void Validate()
        {
            btn测试服务器.Enabled = false;
            this.Cursor = Cursors.AppStarting;
            if (HttpHelper.CheckUri(string.Format("{0}/demo.aspx", txtIp.Text)))
            { this.ShowSuccessTip("成功"); }
            else { this.ShowErrorTip("失败"); }
            btn测试服务器.Enabled = true;
            this.Cursor = Cursors.Default;
        }

        private void btn选择路径_Click(object sender, EventArgs e)
        {
            if (folder.ShowDialog() == DialogResult.OK)
            {
                txtPath.Text = folder.SelectedPath;
                MainForm.SaveSettings();
            }
        }

        private void btn打开目录_Click(object sender, EventArgs e)
        {
            Process.Start("explorer.exe", string.Format("\"{0}\"", UserSettings.Current.下载路径));
        }

        private void FrmAdvanced_Load(object sender, EventArgs e)
        {
            propertyGrid.SelectedObject = MainForm;
            LoadSettings();
        }

        private void LoadSettings()
        {
            chk启用下载.Checked = UserSettings.Current.启用下载;
            chk加入用户体验改进计划.Checked = UserSettings.Current.加入用户体验改进计划;
            chk在线解析.Checked = UserSettings.Current.在线解析;
            txtPath.Text = UserSettings.Current.下载路径;
            txtIp.Text = UserSettings.Current.服务器地址;
            chk边听边存.Checked = UserSettings.Current.边听边存;
            chk下载歌词.Checked = UserSettings.Current.下载歌词;
            chk下载封面.Checked = UserSettings.Current.下载封面;
            txtFormat.Text = UserSettings.Current.文件命名格式;
            chk快速切歌调试模式.Checked = UserSettings.Current.快速切歌调试模式;
            num切歌间隔.Value = UserSettings.Current.快速切歌间隔;
        }

        private void SaveSettings()
        {
            UserSettings.Current.启用下载 = chk启用下载.Checked;
            UserSettings.Current.在线解析 = chk在线解析.Checked;
            UserSettings.Current.加入用户体验改进计划 = chk加入用户体验改进计划.Checked;
            UserSettings.Current.边听边存 = chk边听边存.Checked;
            UserSettings.Current.下载歌词 = chk下载歌词.Checked;
            UserSettings.Current.下载封面 = chk下载封面.Checked;
            UserSettings.Current.服务器地址 = txtIp.Text;
            UserSettings.Current.文件命名格式 = txtFormat.Text;
            UserSettings.Current.下载路径 = txtPath.Text;
            UserSettings.Current.快速切歌调试模式 = chk快速切歌调试模式.Checked;
            UserSettings.Current.快速切歌间隔 = num切歌间隔.Value;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void btnApply_Click(object sender, EventArgs e)
        {
            SaveSettings();
            MainForm.LoadSettings();
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            SaveSettings();
            MainForm.SaveSettings();
            MainForm.LoadSettings();
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void btnWelcome_Click(object sender, EventArgs e)
        {
            new FrmWelcome().ShowDialog();
        }

        private void chk启用下载_ValueChanged(object sender, EventArgs e)
        {
            if (chk启用下载.Checked)
            {
                if (Debugger.IsAttached)
                {
                    this.ShowSuccessTip("我们苦逼程序员们的收入哪能跟明星比?",3000);
                }
                else
                {
                    this.ShowSuccessTip("音乐平台不易,建议到对应音乐平台支持正版资源.", 3000);
                }
            }
        }
    }
}